/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.unnamedanimalmod.common.entity;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import teamdraco.unnamedanimalmod.init.UAMItems;

public class SpottedGardenEelEntity
extends AbstractFishEntity {
    private static final DataParameter<Boolean> HIDDEN = EntityDataManager.func_187226_a(SpottedGardenEelEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final String HIDDEN_DATA = "Hidden";

    public SpottedGardenEelEntity(EntityType<? extends SpottedGardenEelEntity> type, World world) {
        super(type, world);
        this.field_70765_h = new MoveHelperController(this);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new SwimmerPathNavigator((MobEntity)this, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, (Goal)new HideGoal());
        if (!this.isHidden()) {
            this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 10.0f, 2.0, 2.5));
            this.field_70714_bg.func_75776_a(6, (Goal)new SwimGoal(this));
        }
    }

    protected boolean func_225511_J_() {
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HIDDEN, (Object)false);
    }

    public ItemStack getPickedResult(RayTraceResult result) {
        return new ItemStack((IItemProvider)UAMItems.SPOTTED_GARDEN_EEL_SPAWN_EGG.get());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setBurrowed(compound.func_74767_n(HIDDEN_DATA));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a(HIDDEN_DATA, false);
    }

    public boolean isHidden() {
        return (Boolean)this.field_70180_af.func_187225_a(HIDDEN);
    }

    public void setBurrowed(boolean hide) {
        this.field_70180_af.func_187227_b(HIDDEN, (Object)hide);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.isHidden() && this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177977_b()).func_185904_a() != Material.field_151595_p) {
            this.setBurrowed(false);
        }
    }

    protected ItemStack func_203707_dx() {
        return new ItemStack((IItemProvider)UAMItems.SPOTTED_GARDEN_EEL_BUCKET.get());
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX() || this.isHidden();
    }

    protected SoundEvent func_203701_dz() {
        return null;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_204411_iV;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_204412_iW;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_204414_iY;
    }

    public boolean func_70104_M() {
        return !this.isHidden();
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 8.0).func_233815_a_(Attributes.field_233821_d_, 0.7);
    }

    public float func_213307_e(Pose p_213307_1_) {
        return this.isHidden() ? 0.65f : 0.1f;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.func_70107_b(this.func_226282_d_(1.5), this.func_226278_cu_(), this.func_226287_g_(1.5));
        return spawnDataIn;
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(0.01f, travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(travelVector);
        }
    }

    class HideGoal
    extends Goal {
        private int hideTicks = 30;

        public HideGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean func_75250_a() {
            return !SpottedGardenEelEntity.this.isHidden() && this.belowIsSand();
        }

        public void func_75251_c() {
            this.hideTicks = 30;
        }

        public void func_75246_d() {
            if (SpottedGardenEelEntity.this.func_70090_H() && --this.hideTicks <= 0) {
                SpottedGardenEelEntity.this.setBurrowed(true);
                this.hideTicks = 30;
            }
        }

        private boolean belowIsSand() {
            return SpottedGardenEelEntity.this.field_70170_p.func_180495_p(SpottedGardenEelEntity.this.func_233580_cy_().func_177979_c(1)).func_185904_a() == Material.field_151595_p;
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final AbstractFishEntity fish;

        MoveHelperController(AbstractFishEntity p_i48857_1_) {
            super((MobEntity)p_i48857_1_);
            this.fish = p_i48857_1_;
        }

        public void func_75641_c() {
            if (this.fish.func_208600_a((ITag)FluidTags.field_206959_a)) {
                this.fish.func_213317_d(this.fish.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.fish.func_70661_as().func_75500_f()) {
                float f = (float)(this.field_75645_e * this.fish.func_233637_b_(Attributes.field_233821_d_));
                this.fish.func_70659_e(MathHelper.func_219799_g((float)0.125f, (float)this.fish.func_70689_ay(), (float)f));
                double d0 = this.field_75646_b - this.fish.func_226277_ct_();
                double d1 = this.field_75647_c - this.fish.func_226278_cu_();
                double d2 = this.field_75644_d - this.fish.func_226281_cx_();
                if (d1 != 0.0) {
                    double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                    this.fish.func_213317_d(this.fish.func_213322_ci().func_72441_c(0.0, (double)this.fish.func_70689_ay() * (d1 / d3) * 0.1, 0.0));
                }
                if (d0 != 0.0 || d2 != 0.0) {
                    float f1 = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.fish.field_70761_aq = this.fish.field_70177_z = this.func_75639_a(this.fish.field_70177_z, f1, 90.0f);
                }
            } else {
                this.fish.func_70659_e(0.0f);
            }
        }
    }

    static class SwimGoal
    extends RandomSwimmingGoal {
        private final SpottedGardenEelEntity eel;

        public SwimGoal(SpottedGardenEelEntity eel) {
            super((CreatureEntity)eel, 1.0, 40);
            this.eel = eel;
        }

        public boolean func_75250_a() {
            return super.func_75250_a();
        }
    }
}

